package com.example.demo;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.annotation.RetryableTopic;
import org.springframework.kafka.retrytopic.DeadLetterPublishingRecovererFactory;
import org.springframework.kafka.retrytopic.DestinationTopicResolver;

@SpringBootApplication
public class DemoApplication {

  public static void main(String[] args) {
    SpringApplication.run(DemoApplication.class, args);
  }

  @RetryableTopic
  @KafkaListener(topics = "${kafka.topic}", groupId = "id")
  public void listen(String message) {

  }

  @Bean("internalDeadLetterPublishingRecovererProvider")
  public DeadLetterPublishingRecovererFactory retryTopicConfiguration(DestinationTopicResolver destinationTopicResolver) {
    return new DeadLetterPublishingRecovererFactory(destinationTopicResolver);
  }
}
